<?php
session_start();

if(!function_exists('sqlite_escape_string')){
    function sqlite_escape_string($string) {
        return str_replace("'", "''", $string);
    }
}
if (count($_GET) == 0) {$_SESSION=array();}

$mtime = microtime();
$mtime = explode(" ", $mtime);
$mtime = $mtime[1] + $mtime[0];
$starttime = $mtime;

include("config.inc.php");
include("lang/".$setting["Language"].".lng");

if (stripos($_SERVER['HTTP_USER_AGENT'],'yabas') == 0 ) { $IsNMT = 0; } else { $IsNMT = 1; }

if (isset($_GET["template"]) && $_GET["template"] == '') {unset($_SESSION["template"]);}
if (isset($_GET["template"]) && $_GET["template"] != '') {
        $_SESSION["template"]=$_GET["template"];
} elseif (isset($_SESSION["template"]) == FALSE OR $_SESSION["template"] == '') {
        if ($IsNMT == 0) {
                $_SESSION["template"]=$setting["template"];
        } else {
                $_SESSION["template"]=$setting["AlternativeTemplate"];
        }
}

include("templates/".$_SESSION["template"]."/theme.inc.php");

if (isset($_GET["max"]) && $_GET["max"] == '') {
        unset($_SESSION["ShowsPerPage"]);
}
if (isset($_GET["max"]) && $_GET["max"] != '') {
        $_SESSION["ShowsPerPage"]=$_GET["max"];
} elseif (isset($_SESSION["ShowsPerPage"]) == FALSE OR $_SESSION["ShowsPerPage"] == '' OR $_SESSION["ShowsPerPage"] == 'i') {
        $_SESSION["ShowsPerPage"] = $theme["ShowsPerPage"];
}
$tf = "templates/" . $_SESSION["template"] . "/";
$NMJConnectString='sqlite:'.$setting["DB"];

$file = basename($_SERVER['PHP_SELF']);




# ---------------------------------------------------------
# End of Enviroment


$dbh = new PDO($NMJConnectString);


if (isset($_GET["SHOW_ID"])) {
        $show_id = $_GET["SHOW_ID"];
        $view = "detail";
        $criterianame = $language["details"];
} elseif (isset($_GET["statistic"])) {
        $view = "statistic";
        $criterianame = $language["statistic"];
} else {
        $view = "list";
}

$page["ShowOverallCount"] = $dbh->query('SELECT COUNT(*) AS COUNT FROM SHOW')->fetch(PDO::FETCH_COLUMN);


# -Page creation-------------------------------------------
# ---------------------------------------------------------

if ($view == "detail") {

# ---------------------------------------------------------
# ---------------------- DETAIL VIEW ----------------------
# ---------------------------------------------------------
        $show_id = sqlite_escape_string($show_id);
        $detailsql = ' SHOW_ID = '.$show_id;
        $_SESSION["valuename"] = '';
        $page["NumberOfPages"] = 1;
        $page["ShowCount"] = 1;

        $movie = $dbh->query('SELECT * FROM SHOW WHERE '.$detailsql)->fetch(PDO::FETCH_ASSOC);

        MovieData();

        // Genre, only for details
        $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE TYPE="GENRE" AND ' . $detailsql;
        foreach ($dbh->query($sql) as $genre) {
                $movie["GENRE"] .= '<a class ="genre" href="?criteria=genre&value=' .  $genre['VALUE'] . '">' .  $genre['VALUE'] . '</a> | ';
        }
        $movie["GENRE"] = substr($movie["GENRE"],0,strlen-3);

        // Actors, only for details
        $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE TYPE="PRINCIPAL_CAST_MEMBER" AND ' . $detailsql;
        foreach ($dbh->query($sql) as $actor) {
                $movie["ACTORS"] .= '<a class ="person" href="?criteria=person&value=' .  $actor['VALUE'] . '">' .  $actor['VALUE'] . '</a> | ';
        }
        $movie["ACTORS"] = substr($movie["ACTORS"],0,strlen-3);

        // Directors, only for details
        $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE TYPE="DIRECTOR" AND ' . $detailsql;
        foreach ($dbh->query($sql) as $director) {
                $movie["DIRECTOR"] .= '<a class ="person" href="?criteria=person&value=' .  $director['VALUE'] . '">' .  $director['VALUE'] . '</a> | ';
        }
        $movie["DIRECTOR"] = substr($movie["DIRECTOR"],0,strlen-3);

        if ($movie["WALLPAPER"] != $language["unknown"]) {
                $page["WALLPAPER"] = $movie["WALLPAPER"];
        }else{
                $page["WALLPAPER"] = $tf . $theme["wallpaper"];
        }

        if ($movie["SHOW_TYPE"] == 3) { //Movie single file
                $page["StartLink"] = "MOVIE1";
        } elseif ($movie["SHOW_TYPE"] == 1) { // Movie multiple files
                $page["StartLink"] = "1";
        } elseif ($movie["SHOW_TYPE"] == 0) { // Serie
                if (isset($_GET["SEASON"])) {
                        $page["StartLink"] = "1";
                }else {
                        $page["StartLink"] = "season1";
                }
        }

        $valuename = $movie["TITLE"];

        include($tf."header.tpl");
        include($tf.'navigation.tpl');
        include($tf."detail.tpl");

} elseif ($view == "statistic") {

# ---------------------------------------------------------
# ---------------------- STATISTICS -----------------------
# ---------------------------------------------------------
        $_SESSION["valuename"] = '';
        $page["NumberOfPages"] = 1;
        $page["ShowCount"] = 1;

        $tablehtml = '<table class="statistic" >';
        $th1 = '<tr><th class="statistic_name"><font color="#000000">';
        $th2 = '</font></th><th class="statistic_count"><font color="#000000">' . $language["count"] . '</font></th><th class="statistic_percentage"><font color="#000000">' . $language["percentage"] . '</font></th></tr>';
        $factor = 5;

        $page["WALLPAPER"] = $tf.$theme["wallpaper"];
        $page["StartLink"] = "1";
        include($tf."header.tpl");
        include($tf.'navigation.tpl');

        echo '<table id="content" width="100%" border="0" cellpadding="0" cellspacing="0"><tr><td align="center">';
        echo '<center><a href="#year" name="1">' . $language["year"] . '</a> | <a href="#genre" name="2">' . $language["genre"] . '</a> | <a href="#rating" name="3">' . $language["rating"] . '</a> | <a href="#mpaa" name="4">' . $language["mpaa"] . '</a> | <a href="#director" name="5">TOP 30 ' . $language["directors"] . '</a> | <a href="#actor" name="6">TOP 30 ' . $language["actors"] . '</a> | <a href="#codec" name="7">' . $language["codecs"] . '</a></center><br>';


        echo '<a name="year">&nbsp;</a>' . $language["year"] . '<br><br>';
        echo $tablehtml;
        echo $th1.$language["year"].$th2;

        // $sql = 'SELECT distinct PARENTAL_RATING FROM SHOW ORDER BY PARENTAL_RATING DESC';
        // $pgs = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        // foreach ($pgs as $pg) {
        // echo $pg["PARENTAL_RATING"].'<br>';
        // }


        $sql = 'SELECT COUNT(*) AS COUNT ,substr(RELEASE_DATE,1,4) AS YEAR FROM SHOW GROUP BY substr(RELEASE_DATE,0,5) ORDER BY YEAR DESC';
        $stat_years = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);

        foreach ($stat_years as $stat_year) {
                if ($stat_year["YEAR"] == '') {
                        $stat_display_name = $language["unknown"];
                } else {
                        $stat_display_name = '';
                }
                $stat_name = '<a href="?criteria=year&value='.$stat_year["YEAR"].'">'.$stat_year["YEAR"].$stat_display_name.'</a>';
                $stat_count = $stat_year["COUNT"];
                $stat_percentage = $stat_count / $page["ShowOverallCount"] * 100;
                echo '<tr><td align="right" class="statistic_item">' . $stat_name . '</td><td class="statistic_item" align="center">' . $stat_count . '</td><td class="statistic_item" nowrap><img src="' . $tf . $theme["percentage"].'" border="0" height="13" width="' . $factor * $stat_percentage . '">' . round($stat_percentage,2) . '%</td></tr>';
        }
        echo '</table><br><br>';

        echo '<a name="genre">&nbsp;</a>' . $language["genre"] . '<br><br>';
        echo $tablehtml;
        echo $th1.$language["genre"].$th2;

        $sql = 'SELECT COUNT(*) AS COUNT ,GENRE FROM VIDEO_GENRE GROUP BY GENRE ORDER BY COUNT DESC';
        $stat_genres = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        foreach ($stat_genres as $stat_genre) {
                $stat_name = '<a href="?criteria=genre&value='.$stat_genre["GENRE"].'">'.$stat_genre["GENRE"].'</a>';
                $stat_count = $stat_genre["COUNT"];
                $stat_percentage = $stat_count / $page["ShowOverallCount"] * 100;
                echo '<tr><td align="right" class="statistic_item">' . $stat_name . '</td><td class="statistic_item" align="center">' . $stat_count . '</td><td class="statistic_item" nowrap><img src="' . $tf . $theme["percentage"].'" border="0" height="13" width="' . $factor * $stat_percentage . '">' . round($stat_percentage,2) . '%</td></tr>';
        }
        echo '</table><br><br>';

        echo '<a name="rating">&nbsp;</a>' . $language["rating"] . '<br><br>';
        echo $tablehtml;
        echo $th1.$language["rating"].$th2;

        for ($i = 1; $i <= 10; $i++) {
                $rating_count = $dbh->query('SELECT COUNT(*) AS COUNT FROM SHOW WHERE RATING = '.$i)->fetch(PDO::FETCH_COLUMN);
                $stat_name = '<a href="?criteria=rating&value='.$i.'">'.$i.'</a>';
                $stat_count = $rating_count;
                $stat_percentage = $stat_count / $page["ShowOverallCount"] * 100;
                echo '<tr><td align="right" class="statistic_item">' . $stat_name . '</td><td class="statistic_item" align="center">' . $stat_count . '</td><td class="statistic_item" nowrap><img src="' . $tf . $theme["percentage"].'" border="0" height="13" width="' . $factor * $stat_percentage . '">' . round($stat_percentage,2) . '%</td></tr>';
        }
        echo '</table><br><br>';

        echo '<a name="mpaa">&nbsp;</a>' . $language["mpaa"] . '<br><br>';
        echo $tablehtml;
        echo $th1.$language["mpaa"].$th2;

        $sql = 'SELECT COUNT(*) AS COUNT ,PARENTAL_RATING FROM SHOW GROUP BY PARENTAL_RATING ORDER BY PARENTAL_RATING';
        $stat_pgs = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        foreach ($stat_pgs as $stat_pg) {
                if ($stat_pg["PARENTAL_RATING"] == '') {
                        $stat_display_name = $language["unknown"];
                } else {
                        $stat_display_name = '';
                }
                $stat_name = '<a href="?criteria=mpaa&value='.$stat_pg["PARENTAL_RATING"].'">'.$stat_pg["PARENTAL_RATING"].$stat_display_name.'</a>';
                $stat_count = $stat_pg["COUNT"];
                $stat_percentage = $stat_count / $page["ShowOverallCount"] * 100;
                echo '<tr><td align="right" class="statistic_item">' . $stat_name . '</td><td class="statistic_item" align="center">' . $stat_count . '</td><td class="statistic_item" nowrap><img src="' . $tf . $theme["percentage"].'" border="0" height="13" width="' . $factor * $stat_percentage . '">' . round($stat_percentage,2) . '%</td></tr>';
        }
        echo '</table><br><br>';

        echo '<a name="director">&nbsp;</a>TOP 30 ' . $language["directors"] . '<br><br>';
        echo $tablehtml;
        echo $th1.$language["director"].$th2;

        $sql = "SELECT COUNT, DIRECTOR FROM (SELECT COUNT(*) AS COUNT ,VALUE AS DIRECTOR  FROM VIDEO_ATTR WHERE TYPE = 'DIRECTOR' GROUP BY VALUE) ORDER BY COUNT DESC LIMIT 30";
        $stat_directors = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        foreach ($stat_directors as $stat_director) {
                $stat_name = '<a href="?criteria=director&value='.$stat_director["DIRECTOR"].'">'.$stat_director["DIRECTOR"].'</a>';
                $stat_count = $stat_director["COUNT"];
                $stat_percentage = $stat_count / $page["ShowOverallCount"] * 100;
                echo '<tr><td align="right" class="statistic_item">' . $stat_name . '</td><td class="statistic_item" align="center">' . $stat_count . '</td><td class="statistic_item" nowrap><img src="' . $tf . $theme["percentage"].'" border="0" height="13" width="' . $factor * $stat_percentage . '">' . round($stat_percentage,2) . '%</td></tr>';
                }
        echo '</table><br><br>';

        echo '<a name="actor">&nbsp;</a>TOP 30 ' . $language["actors"] . '<br><br>';
        echo $tablehtml;
        echo $th1.$language["actor"].$th2;

        $sql = "SELECT COUNT, ACTOR FROM (SELECT COUNT(*) AS COUNT ,VALUE AS ACTOR FROM VIDEO_ATTR WHERE TYPE = 'PRINCIPAL_CAST_MEMBER'  AND SHOW_ID is not null GROUP BY VALUE) ORDER BY COUNT DESC LIMIT 30";
        $stat_actors = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        foreach ($stat_actors as $stat_actor) {
                $stat_name = '<a href="?criteria=actor&value='.$stat_actor["ACTOR"].'">'.$stat_actor["ACTOR"].'</a>';
                $stat_count = $stat_actor["COUNT"];
                $stat_percentage = $stat_count / $page["ShowOverallCount"] * 100;
                echo '<tr><td align="right" class="statistic_item">' . $stat_name . '</td><td class="statistic_item" align="center">' . $stat_count . '</td><td class="statistic_item" nowrap><img src="' . $tf . $theme["percentage"].'" border="0" height="13" width="' . $factor * $stat_percentage . '">' . round($stat_percentage,2) . '%</td></tr>';
                }
        echo '</table><br><br>';

        echo '<a name="codec">&nbsp;</a>' . $language["codecs"] . '<br><br>';
        echo $tablehtml;
        echo $th1.$language["codec"].$th2;

        $sql = "SELECT COUNT(*) AS COUNT ,SYSTEM FROM SHOW GROUP BY SYSTEM ORDER BY COUNT DESC";
        $stat_codecs = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
        foreach ($stat_codecs as $stat_codec) {
                if ($stat_codec["SYSTEM"] == '') {
                        $stat_display_name = $language["unknown"];
                } else {
                        $stat_display_name = '';
                }
                $stat_name = '<a href="?criteria=codec&value='.$stat_codec["SYSTEM"].'">'.$stat_codec["SYSTEM"].'</a>';
                $stat_count = $stat_codec["COUNT"];
                $stat_percentage = $stat_count / $page["ShowOverallCount"] * 100;
                echo '<tr><td align="right" class="statistic_item">' . $stat_name . '</td><td class="statistic_item" align="center">' . $stat_count . '</td><td class="statistic_item" nowrap><img src="' . $tf . $theme["percentage"].'" border="0" height="13" width="' . $factor * $stat_percentage . '">' . round($stat_percentage,2) . '%</td></tr>';
                        }
        echo '</table>';
        echo '</td></tr></table>';

} else {

# ---------------------------------------------------------
# ---------------------THUMBNAIL LIST----------------------
# ---------------------------------------------------------
        $page["WALLPAPER"] = $tf.$theme["wallpaper"];
        $page["StartLink"] = "1";
        include($tf."header.tpl");

# -Prepare SQL Query---------------------------------------
# ---------------------------------------------------------

        if (isset($_GET["criteria"]) && isset($_GET["value"])){
                $criteria = sqlite_escape_string($_GET["criteria"]);
                $criterianame = $language[$criteria];
                $value = sqlite_escape_string($_GET["value"]);

                switch (strtolower($criteria)) {
                        case 'category':
                                $valuename = $dbh->query('SELECT NAME FROM VIDEO_GROUP_NAME WHERE VIDEO_GROUP_NAME_ID = ' . $value . ' LIMIT 1')->fetch(PDO::FETCH_COLUMN);
                                $criteriasql = " SHOW_ID in (SELECT SHOW_ID FROM VIDEO_GROUP INNER JOIN VIDEO_GROUP_NAME on VIDEO_GROUP. VIDEO_GROUP_NAME_ID = VIDEO_GROUP_NAME.VIDEO_GROUP_NAME_ID AND VIDEO_GROUP_NAME.VIDEO_GROUP_NAME_ID = " . $value . ")";
                                break;
                        case 'genre':
                                $valuename = $value;
                                $criteriasql = " SHOW_ID in (SELECT VIDEO_SHOW_ID FROM VIDEO_GENRE WHERE GENRE = '" . $value . "')";
                                break;
                        case 'person':
                                $valuename = $value;
                                $criteriasql = " SHOW_ID in (SELECT VIDEO_ATTR.SHOW_ID FROM VIDEO_ATTR WHERE VALUE = '" . $value . "')";
                                break;
                        case 'actor':
                                $valuename = $value;
                                $criteriasql = " SHOW_ID in (SELECT VIDEO_ATTR.SHOW_ID FROM VIDEO_ATTR WHERE TYPE = 'PRINCIPAL_CAST_MEMBER' AND VALUE = '" . $value . "')";
                                break;
                        case 'director':
                                $valuename = $value;
                                $criteriasql = " SHOW_ID in (SELECT VIDEO_ATTR.SHOW_ID FROM VIDEO_ATTR WHERE TYPE = 'DIRECTOR' AND VALUE = '" . $value . "')";
                                break;
                        case 'mpaa':
                                $valuename = $value;
                                $criteriasql = " SHOW_ID in (SELECT SHOW_ID FROM SHOW WHERE PARENTAL_RATING = '" . $value . "')";
                                break;
                        case 'codec':
                                $valuename = $value;
                                $criteriasql = " SHOW_ID in (SELECT SHOW_ID FROM SHOW WHERE SYSTEM = '" . $value . "')";
                                break;
                        case 'rating':
                                $valuename = $value;
                                $criterianame = $language[$criteria];
                                $criteriasql = " cast(round(RATING) as integer) = " . $value;
                                break;
                        case 'year':
                                $valuename = $value;
                                $criteriasql = " substr(RELEASE_DATE,1,4) = '" . $value . "'";
                                break;
                        case 'show_type':
                                if ($value == 0) {
                                        $valuename = '';
                                        $criterianame = $language["serie"];
                                } else {
                                        $criterianame = $language["movies"];
                                        $valuename = '';
                                }
                                $criteriasql = $criteria . "=" . $value;
                                break;
                        case 'title':
                                $valuename = $value;
                                $criteriasql = " TITLE LIKE '%" . $value . "%'";
                                break;
                        case 'search':
                                $valuename = $value;
                                $criteriasql = " TITLE LIKE '%" . $value . "%' or SHOW_ID in (SELECT SHOW_ID FROM VIDEO_ATTR WHERE TYPE IN ('DIRECTOR','PRINCIPAL_CAST_MEMBER') AND  VALUE LIKE '%" . $value . "%')";
                                break;
                        default:
                                $criteriasql = $criteria . "=" . $value;
                }

        } else { //Starting setup is Latest added shows
                $value = "";
                $valuename = $value;
                $criteria = 'title';
                $criterianame = $language["added"];
                $criteriasql = "TITLE LIKE '%" . $value ."%'";
        }

        # -Session information ------------------------------------
        # ---------------------------------------------------------

        $_SESSION["criteria"] = $criteria;
        $_SESSION["criterianame"] = $criterianame;
        $_SESSION["value"] = $value;
        $_SESSION["valuename"] = $valuename;

        # -Final SQL Queries --------------------------------------
        # ---------------------------------------------------------

        if (isset($_GET["counter"])) {
                $page["page"] = $_GET["counter"];
                $counter = $_GET["counter"] * $_SESSION["ShowsPerPage"];
        } else {
                $page["page"] = 0;
                $counter = 0;
        }
        if (isset($_COOKIE["max"]) && $_COOKIE["max"] != '' && $_COOKIE["max"] != 'NaN' && $theme["GetShowsPerPageAutomatically"] == 1) {
                $_SESSION["ShowsPerPage"]=$_COOKIE["max"];
        }

        $countersql = " LIMIT " . $counter . "," . $_SESSION["ShowsPerPage"];
        $sql = 'FROM SHOW WHERE ' . $criteriasql . $countersql;
        //echo $sql;
        $mastersql = 'SELECT * '.$sql;
        //echo $mastersql;
        $tvid = 1;

        # -Basic navigation information ---------------------------
        # ---------------------------------------------------------

        $CriteriaCountSQL = 'SELECT COUNT(*) AS COUNT FROM SHOW WHERE ' . $criteriasql;
        $page["ShowsPerPage"] = $_SESSION["ShowsPerPage"];
        $page["ShowCount"] = $dbh->query($CriteriaCountSQL)->fetch(PDO::FETCH_COLUMN);
        $page["NumberOfPages"] = ceil($page["ShowCount"] / $_SESSION["ShowsPerPage"]);
        if ($page["page"] == $page["NumberOfPages"] -1) {
                $page["PrevPage"] = $page["page"] - 1;
                $page["NextPage"] = 0;
        } elseif ($page["page"] == 0) {
                $page["PrevPage"] = $page["NumberOfPages"] - 1;
                $page["NextPage"] = 1;
        } else {
                $page["PrevPage"] = $page["page"] - 1;
                $page["NextPage"] = $page["page"] + 1;
        }
        if ($page["NumberOfPages"] == 1) {
                $page["PrevPage"] = 0;
                $page["NextPage"] = 0;
        }
        $page["PrevPageLink"] = '?criteria='.$criteria.'&value='.$value.'&counter='.$page["PrevPage"];
        $page["NextPageLink"] = '?criteria='.$criteria.'&value='.$value.'&counter='.$page["NextPage"];

        $movies = $dbh->query('SELECT * '.$sql)->fetchAll(PDO::FETCH_ASSOC);

        include($tf.'navigation.tpl');
        include($tf.'thumbnail_list_header.tpl');
        $cur_movie = 1;

        foreach ($movies as $movie) {

                MovieData();

                if ($IsNMT != TRUE) {
                        include($tf."show_thumb.tpl");
                } else {
                        include($tf."show_thumb_nmt.tpl");
                }
                if ($cur_movie++ == $theme["ShowsPerRow"]) {
                        echo $theme["RowDivider"];
                        $cur_movie = 1;
                }

        }
        include($tf.'thumbnail_list_footer.tpl');
}

function MovieData() {

        global $tf,$movie,$drive,$language,$theme,$dbh,$page;

        foreach ($movie as $key => $value) {
                if ($value == '' ) {
                        $movie[$key] = $language["unknown"];
                } else {
                        $movie[$key] = str_replace(chr(39),"`",$movie[$key]);
                        $movie[$key] = htmlspecialchars($movie[$key], ENT_QUOTES) ;
                }
        }

        $sql = 'SELECT CONTENT FROM VIDEO_SYNOPSIS WHERE SHOW_ID = ' . $movie["SHOW_ID"];
        $movie["PLOT"] = $dbh->query($sql)->fetch(PDO::FETCH_COLUMN);

        $sql = 'SELECT SUM(RUNTIME) FROM VIDEO WHERE SHOW_ID = ' . $movie["SHOW_ID"];
        $movie["RUNTIME"] = $dbh->query($sql)->fetch(PDO::FETCH_COLUMN);
        if ($movie["RUNTIME"] != 0) {
                $movie["RUNTIME"] = $movie["RUNTIME"]/60;
                $hour =  floor($movie["RUNTIME"]/60);
                $minute = $movie["RUNTIME"] - ($hour*60);
                if ($minute <10) {$minute = "0".$minute;}
                $movie["RUNTIME"] = $hour . 'h ' . $minute . 'min';
        }

        $movie["YEAR"] = substr($movie["RELEASE_DATE"],0,4);
        $movie["RATING_IMAGES"] = str_repeat('<img src="' . $tf . '/' . $theme["RatingImage"] . '"  border="0">', round($movie["RATING"])) . str_repeat('<img src="' . $tf . '/' . $theme["NoRatingImage"] . '"  border="0">', 10 - round($movie["RATING"]));
        $movie["RATING_IMAGES_small"] = str_repeat('<img src="' . $tf . '/' . $theme["RatingImageSmall"] . '"  border="0">', round($movie["RATING"]));

        $sql = 'SELECT PATH,VIDEO1,WIDTH,PARENTAL_RATING FROM VIDEO WHERE SHOW_ID = ' . $movie["SHOW_ID"] .' LIMIT 1';
        $show_video = $dbh->query($sql)->fetch(PDO::FETCH_ASSOC);
        $movie["PATH"] = $show_video["PATH"];
        $movie["LONGPATH"] = $drive[$show_video["VIDEO1"]] . $movie["PATH"];
        if ($movie["WIDTH"] == '') { $movie["WIDTH"] = $show_video["WIDTH"];}
        if ($movie["PARENTAL_RATING"] == '') { $movie["PARENTAL_RATING"] = $show_video["PARENTAL_RATING"];}

        $sql = 'SELECT min(PLAY_COUNT) AS SEEN FROM VIDEO WHERE SHOW_ID = ' . $movie["SHOW_ID"];
        $movie["SEEN"] = $dbh->query($sql)->fetch(PDO::FETCH_COLUMN);

        if ($movie["SEEN"] != 0) {
                $movie["SEEN"] = 'seen';
        } else {
                $movie["SEEN"] = 'not-seen';
        }

        if ($movie["WIDTH"] == '1920') {
                $movie["HD"] = 'FHD';
        } elseif ($movie["WIDTH"] == '1280')  {
                $movie["HD"] = 'HD';
        } else {
                $movie["HD"] = 'unknown';
        }
}
function Seasons($show_id,$show_type,$display='table',$order='asc') {
        global $tf,$drive,$language,$theme,$NMJConnectString;

        $dbh = new PDO($NMJConnectString);

        if ($display == 'table') {
                        $tablehtml = '<table class = "seasons">';
                        $trhtml = '<tr>';
                        $trhtml_close = '</tr>';
                        $tablehtml_close = '</table>';
                } elseif ($display == 'div') {
                        $tablehtml = '<div class = "seasons">';
                        $trhtml = '';
                        $trhtml_close = '';
                        $tablehtml_close = '</div>';
                }

        switch ($show_type) {
                case 0: //Serie
                        $sql = 'SELECT DISTINCT SHOW_ID, SEASON FROM VIDEO WHERE SHOW_ID=' . $show_id . ' ORDER BY SEASON '.$order;
                         echo $sql;
                        $seasons = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                        $i = 1;
                        echo $tablehtml.$trhtml;
                        foreach ($seasons as $season) {
                                include($tf."season_list.tpl");
                                if ($i++ == $theme["SeasonsPerRow"]) { $i = 1; echo $trhtml_close.$trhtml; }
                        }
                        echo $trhtml_close.$tablehtml_close;
                        break;
                case 1: //Movie, multiple parts
                        $tvid = 1;
                        $count = $dbh->query('SELECT COUNT(*) AS COUNT FROM VIDEO WHERE SHOW_ID = ' . $show_id)->fetch(PDO::FETCH_COLUMN);
                        $sql = 'SELECT * FROM VIDEO WHERE SHOW_ID=' . $show_id . ' ORDER BY PATH '.$order;
                        $videos = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);

                        echo $tablehtml.$trhtml;
                        foreach ($videos as $video) {
                                if ($video["TITLE"] == '') {
                                        $video["TITLE"] = 'Part ' . $tvid;
                                }
                                $video["LONGPATH"] = $drive[$video["VIDEO1"]] . $video["PATH"];
                                $video["RUNTIME"] = $video["RUNTIME"]/60 .' min';
                                include($tf."videos_for_movie.tpl");
                        }
                        echo $trhtml_close.$tablehtml_close;
                        break;
                }
}
function Episodes($display) {

        global $tf,$drive,$language,$NMJConnectString,$theme,$show_id;

        if (isset($_GET["SEASON"])) { // Generate Episode list

                if ($display == 'table') {
                        $tablehtml = '<table class = "episodeTable"><tr>';
                        $trhtml = '<tr>';
                        $trhtml_close = '</tr>';
                        $tablehtml_close = '</table>';
                } elseif ($display == 'div') {
                        $tablehtml = '<div class = "episode">';
                        $trhtml = '';
                        $trhtml_close = '';
                        $tablehtml_close = '</div>';
                }

                $dbh = new PDO($NMJConnectString);

                $season = $_GET["SEASON"];

                $sql = "SELECT VIDEO.* FROM VIDEO INNER JOIN SHOW ON SHOW.SHOW_ID = VIDEO.SHOW_ID WHERE SEASON = " . $season . " AND VIDEO.SHOW_ID = " . $show_id . " ORDER BY EPISODE";
                echo $tablehtml;
                $videos = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                $i = 0;
                $tvid = 1;
                foreach ($videos as $video) {

                        $video["LONGPATH"] = $drive[$video["VIDEO1"]] . $video["PATH"];
                        if ($video["RUNTIME"] != '') {
                                $video["RUNTIME"] = $video["RUNTIME"] . ' min';
                        }

                        $sql = 'SELECT CONTENT FROM VIDEO_SYNOPSIS WHERE VIDEO_ID = ' . $video["VIDEO_ID"];
                        $plot = $dbh->query($sql)->fetch(PDO::FETCH_ASSOC);
                        $video["PLOT"] = $plot["CONTENT"];

                        $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE TYPE="PRINCIPAL_CAST_MEMBER" AND VIDEO_ID = ' . $video["VIDEO_ID"];
                        foreach ($dbh->query($sql) as $actor) {
                                $video["ACTORS"] .= '<a class ="person" href="?criteria=person&value=' .  $actor['VALUE'] . '">' .  $actor['VALUE'] . '</a> | ';
                        }
                        $video["ACTORS"] = substr($video["ACTORS"],0,strlen-3);

                        $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE TYPE="DIRECTOR" AND VIDEO_ID = ' . $video["VIDEO_ID"];
                        foreach ($dbh->query($sql) as $director) {
                                $video["DIRECTOR"] .= '<a class ="person" href="?criteria=person&value=' .  $director['VALUE'] . '">' .  $director['VALUE'] . '</a> | ';
                        }
                        $video["DIRECTOR"] = substr($video["DIRECTOR"],0,strlen-3);
                        if ($i++ == $theme["EpisodesPerRow"]) { $i = 1; echo $trhtml_close.$trhtml; }
                        include($tf."videos_for_episodes.tpl");
                }
                echo $tablehtml_close;
        }
}
function navigation($type,$display,$columns=2) {

        global $tf,$view,$language,$NMJConnectString,$theme,$IsNMT;
        if ($IsNMT == 0 OR  $display == 'NoShow') {
                if ($view == 'detail' && $display == 'NoShow') {} else {
                        $dbh = new PDO($NMJConnectString);

                        if ($display == 'table') {
                                $tablehtml = '<table border="0" cellpadding="0" cellspacing="0" class="sub_navigation" id="sub_nav_'.$type.'"><tr>';
                                $tdhtml = '<td class="sub_navigation_item">';
                                $tdhtml_close = '</td>';
                                $trhtml = '<tr>';
                                $trhtml_close = '</tr>';
                                $tablehtml_close = '</table>';
                        } elseif ($display == 'div') {
                                $tablehtml = '<div class="sub_navigation" id="sub_nav_'.$type.'">';
                                $tdhtml = '<div class="sub_navigation_item">';
                                $tdhtml_close = '</div>';
                                $trhtml = '';
                                $trhtml_close = '';
                                $tablehtml_close = '</div>';
                        } elseif ($display == 'plain') {
                                $tdhtml = '';
                                $tdhtml_close = '';
                        } else {
                                $tdhtml = '  ';
                                $tdhtml_close = ' | ';
                        }

                        echo $tablehtml;

                        switch ($type) {
                                case 'category':
                                        $sql = 'SELECT VIDEO_GROUP_NAME_ID,NAME FROM VIDEO_GROUP_NAME ORDER BY NAME';
                                        $categories = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                                        echo $trhtml;
                                        $ii = 0;
                                        foreach ($categories as $category)
                                        {

                                                $id = $category['VIDEO_GROUP_NAME_ID'];
                                                $name = $category['NAME'];
                                        if ($id != "2" && $id != "3" && $id != "4" && $id != "5" && $id != "9" && $id != "13" && $id != "30")
                                        {
                                                $ii++;
                                                echo $tdhtml;
                                                echo '<a class="navigation_item_link" href="?criteria=' . $type . '&value=' . $id . '">' . $name . '</a>';
                                                echo $tdhtml_close;
                                                if ($ii == $theme["SMCategoryColumns"]) {echo $trhtml_close.$trhtml;$ii = 0;}
                                        }
                                        }
                                        if ($ii != 0) {echo $trhtml_close;}
                                        break;
                                case 'genre':
                                        $sql = 'SELECT DISTINCT GENRE FROM VIDEO_GENRE ORDER BY GENRE';
                                        $genres = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                                        echo $trhtml;
                                        $ii = 0;
                                        foreach ($genres as $genre) {
                                                $ii++;
                                                $thisgenre = $genre['GENRE'];
                                                echo $tdhtml.'<a class="navigation_item_link" href="?criteria=' . $type . '&value=' . $thisgenre . '">' . $thisgenre . '</a>'.$tdhtml_close;
                                                if ($ii == $theme["SMGenreColumns"]) {echo $trhtml_close.$trhtml;$ii = 0;}
                                        }
                                        if ($ii != 0) {echo $trhtml_close;}
                                        break;
                                case 'rating':
                                        $ii = 0;
                                        for ($i = 0; $i <= 10; $i++) {
                                                $ii++;
                                                echo $trhtml.$tdhtml.'<a class="navigation_item_link" href="?criteria=' . $type . '&value=' . $i . '">' . $i . '</a>'.$tdhtml_close.$trhtml_close;
                                                if ($ii == $theme["SMRatingColumns"]) {echo $trhtml_close.$trhtml;$ii = 0;}
                                        }
                                        break;

                        }
                        echo $trhtml_close.$tablehtml_close;
                }
        }
}
function endtime() {
    global $starttime;

    $mtime = microtime();
    $mtime = explode(" ", $mtime);
    $mtime = $mtime[1] + $mtime[0];
    $endtime = $mtime;
    $totaltime = ($endtime - $starttime);
    return substr($totaltime, 0, 5);
}

?>
</div>
</div>
</br></br></br>
<div id="footer">

        <div id="foot">
                <div id="left">
                        <p><img src="./templates/reblabs_klein.png" title="RedLabs" alt="RedLabs" width="260" height="35" border="0" /></p>
                        <p></p>
                </div>
                <div id="right">
                         <p class="axe">
                                 <a href="http://redlabs.info/index.php?zone=contact" target="_blank">Kontakt</a> - PopMovie-WebUI -
                                    Version :<b> 1.0</b>
                         </p>
                         <p>&copy; 2008-2013 RedLabs</p>
                          </br>Optimiert f&uuml;r FF 2.x / FF 3.x | bei 1280x1024

                </div>
        </div>
</div>
</body>