<?php
if(!function_exists('sqlite_escape_string')){
    function sqlite_escape_string($string) {
        return str_replace("'", "''", $string);
    }
}
function MovieData() {

        global $tf,$movie,$drive,$language,$theme,$dbh,$page;

        foreach ($movie as $key => $value) {
                if ($value == '' ) {
                        $movie[$key] = $language["unknown"];
                } else {
                        $movie[$key] = str_replace(chr(39),"`",$movie[$key]);
                        $movie[$key] = $movie[$key];
                }
        }

        $sql = 'SELECT SUMMARY FROM SYNOPSISES WHERE ID = ' . $movie["ID"];

        $movie["PLOT"] = $dbh->query($sql)->fetch(PDO::FETCH_COLUMN);

        $sql = 'SELECT SUM(RUNTIME) FROM SHOWS WHERE ID = ' . $movie["ID"];
        $movie["RUNTIME"] = $dbh->query($sql)->fetch(PDO::FETCH_COLUMN);
        if ($movie["RUNTIME"] != 0) {
                $movie["RUNTIME"] = $movie["RUNTIME"]/60;
                $hour =  floor($movie["RUNTIME"]/60);
                $minute = $movie["RUNTIME"] - ($hour*60);
                if ($minute <10) {$minute = "0".$minute;}
                $movie["RUNTIME"] = $hour . 'h ' . $minute . 'min';
        }

        $movie["YEAR"] = substr($movie["RELEASE_DATE"],0,4);
        $movie["RATING_IMAGES"] = str_repeat('<img src="' . $tf . '/' . $theme["RatingImage"] . '"  border="0">', round($movie["RATING"])) . str_repeat('<img src="' . $tf . '/' . $theme["NoRatingImage"] . '"  border="0">', 10 - round($movie["RATING"]));
        $movie["RATING_IMAGES_small"] = str_repeat('<img src="' . $tf . '/' . $theme["RatingImageSmall"] . '"  border="0">', round($movie["RATING"]));

        $sql = 'SELECT WIDTH,RESOLUTION FROM VIDEO_PROPERTIES WHERE ID = ' . $movie["ID"] .' LIMIT 1';
                 $show_width = $dbh->query($sql)->fetch(PDO::FETCH_ASSOC);
        $sql = 'SELECT TITLE_TYPE,PARENTAL_CONTROL FROM SHOWS WHERE ID = ' . $movie["ID"] .' LIMIT 1';
                 $show_parental = $dbh->query($sql)->fetch(PDO::FETCH_ASSOC);
        $sql = 'SELECT THUMBNAIL,POSTER,WALLPAPER FROM VIDEO_POSTERS WHERE ID = ' . $movie["ID"] .' LIMIT 1';

                 $show_pics = $dbh->query($sql)->fetch(PDO::FETCH_ASSOC);
        $movie["SHOW_TYPE"] =  $show_parental["TITLE_TYPE"];
        $movie["THUMBNAIL"] = $show_pics["THUMBNAIL"];
        $movie["DETAIL_POSTER"] = $show_pics["POSTER"];
        $movie["WALLPAPER"] = $show_pics["WALLPAPER"];
        $movie["RESOLUTION"] = $show_width["RESOLUTION"];

        if ($movie["WIDTH"] == '') { $movie["WIDTH"] = $show_width["WIDTH"];}
        if ($movie["PARENTAL_CONTROL"] == '') { $movie["PARENTAL_CONTROL"] = $show_parental["PARENTAL_CONTROL"];}

        $sql = 'SELECT min(PLAY_COUNT) AS SEEN FROM VIDEOS WHERE ID = 1' . $movie["SHOW_ID"];
        $movie["SEEN"] = $dbh->query($sql)->fetch(PDO::FETCH_COLUMN);

        if ($movie["SEEN"] != 0) {
                $movie["SEEN"] = 'seen';
        } else {
                $movie["SEEN"] = 'not-seen';
        }

        if ($movie["WIDTH"] == '1920') {
                $movie["HD"] = 'FHD';
        } elseif ($movie["WIDTH"] == '1280')  {
                $movie["HD"] = 'HD';
        } else {
                $movie["HD"] = 'unknown';
        }
}
function Seasons($show_id,$show_type,$display='table',$order='asc') {
        global $tf,$drive,$language,$theme,$NMJConnectString;

        $dbh = new PDO($NMJConnectString);

        if ($display == 'table') {
                        $tablehtml = '<table class = "seasons">';
                        $trhtml = '<tr>';
                        $trhtml_close = '</tr>';
                        $tablehtml_close = '</table>';
                } elseif ($display == 'div') {
                        $tablehtml = '<div class = "seasons">';
                        $trhtml = '';
                        $trhtml_close = '';
                        $tablehtml_close = '</div>';
                }

        switch ($show_type) {
                case 2: //Serie
                        $sql = 'SELECT DISTINCT SHOW_ID, SEASON FROM VIDEO WHERE SHOW_ID=' . $show_id . ' ORDER BY SEASON '.$order;
                        $seasons = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                        $i = 1;
                        echo $tablehtml.$trhtml;
                        foreach ($seasons as $season) {
                                include($tf."season_list.tpl");
                                if ($i++ == $theme["SeasonsPerRow"]) { $i = 1; echo $trhtml_close.$trhtml; }
                        }
                        echo $trhtml_close.$tablehtml_close;
                        break;
                case 6: //Movie, multiple parts
                        $tvid = 0;

                        $count = $dbh->query('SELECT COUNT(*) AS COUNT FROM SHOWS_VIDEOS WHERE SHOWS_ID = ' . $show_id)->fetch(PDO::FETCH_ASSOC);
                        $videos = $dbh->query('SELECT (SELECT ID FROM VIDEOS WHERE ID = VIDEOS_ID) as VIDEO_ID FROM SHOWS_VIDEOS WHERE SHOWS_ID = ' . $show_id)->fetchAll(PDO::FETCH_ASSOC);

                        echo $tablehtml.$trhtml;

                        foreach ($videos as $video) {

                                $video_part1 = $dbh->query('SELECT PATH, SIZE FROM VIDEOS WHERE ID = ' . $video['VIDEO_ID'])->fetch(PDO::FETCH_ASSOC);
                                $video_part2 = $dbh->query('SELECT RUNTIME,RESOLUTION,SYSTEM,VIDEO_CODEC FROM VIDEO_PROPERTIES WHERE ID = ' . $video['VIDEO_ID'])->fetch(PDO::FETCH_ASSOC);
                                $video_part["TITLE"] = 'Part ' . $tvid;
                                $video_part["LONGPATH"] = $drive[$video_part["VIDEO1"]] . $video_part1["PATH"];
                                $video_part["RUNTIME"] = round ($video_part2["RUNTIME"]/60, 2 ) .' min';
                                $video_part["SIZE"] = human_filesize($video_part1["SIZE"]);

                                include($tf."videos_for_movie.tpl");
                                $tvid++;
                        }
                        echo $trhtml_close.$tablehtml_close;
                        break;
                case 1: //Movie, multiple parts
                        $tvid = 0;

                        $count = $dbh->query('SELECT COUNT(*) AS COUNT FROM SHOWS_VIDEOS WHERE SHOWS_ID = ' . $show_id)->fetch(PDO::FETCH_ASSOC);
                        $videos = $dbh->query('SELECT (SELECT ID FROM VIDEOS WHERE ID = VIDEOS_ID) as VIDEO_ID FROM SHOWS_VIDEOS WHERE SHOWS_ID = ' . $show_id)->fetchAll(PDO::FETCH_ASSOC);

                        echo $tablehtml.$trhtml;

                        foreach ($videos as $video) {

                                $video_part1 = $dbh->query('SELECT PATH, SIZE FROM VIDEOS WHERE ID = ' . $video['VIDEO_ID'])->fetch(PDO::FETCH_ASSOC);
                                $video_part2 = $dbh->query('SELECT RUNTIME,RESOLUTION,SYSTEM,VIDEO_CODEC FROM VIDEO_PROPERTIES WHERE ID = ' . $video['VIDEO_ID'])->fetch(PDO::FETCH_ASSOC);
                                $video_part["TITLE"] = 'Part ' . $tvid;
                                $video_part["LONGPATH"] = $drive[$video_part["VIDEO1"]] . $video_part1["PATH"];
                                $video_part["RUNTIME"] = round ($video_part2["RUNTIME"]/60, 2 ) .' min';
                                $video_part["SIZE"] = human_filesize($video_part1["SIZE"]);

                                include($tf."videos_for_movie.tpl");
                                $tvid++;
                        }
                        echo $trhtml_close.$tablehtml_close;
                        break;


                }
}
function Episodes($display) {

        global $tf,$drive,$language,$NMJConnectString,$theme,$show_id;

        if (isset($_GET["SEASON"])) { // Generate Episode list

                if ($display == 'table') {
                        $tablehtml = '<table class = "episodeTable"><tr>';
                        $trhtml = '<tr>';
                        $trhtml_close = '</tr>';
                        $tablehtml_close = '</table>';
                } elseif ($display == 'div') {
                        $tablehtml = '<div class = "episode">';
                        $trhtml = '';
                        $trhtml_close = '';
                        $tablehtml_close = '</div>';
                }

                $dbh = new PDO($NMJConnectString);

                $season = $_GET["SEASON"];

                $sql = "SELECT VIDEO.* FROM VIDEO INNER JOIN SHOW ON SHOW.SHOW_ID = VIDEO.SHOW_ID WHERE SEASON = " . $season . " AND VIDEO.SHOW_ID = " . $show_id . " ORDER BY EPISODE";
                echo $tablehtml;
                $videos = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                $i = 0;
                $tvid = 1;
                foreach ($videos as $video) {

                        $video["LONGPATH"] = $drive[$video["VIDEO1"]] . $video["PATH"];
                        if ($video["RUNTIME"] != '') {
                                $video["RUNTIME"] = $video["RUNTIME"] . ' min';
                        }

                        $sql = 'SELECT CONTENT FROM VIDEO_SYNOPSIS WHERE VIDEO_ID = ' . $video["VIDEO_ID"];
                        $plot = $dbh->query($sql)->fetch(PDO::FETCH_ASSOC);
                        $video["PLOT"] = $plot["CONTENT"];

                        $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE TYPE="PRINCIPAL_CAST_MEMBER" AND VIDEO_ID = ' . $video["VIDEO_ID"];
                        foreach ($dbh->query($sql) as $actor) {
                                $video["ACTORS"] .= '<a class ="person" href="?criteria=person&value=' .  $actor['VALUE'] . '">' .  $actor['VALUE'] . '</a> | ';
                        }
                        $video["ACTORS"] = substr($video["ACTORS"],0,strlen-3);

                        $sql = 'SELECT VALUE FROM VIDEO_ATTR WHERE TYPE="DIRECTOR" AND VIDEO_ID = ' . $video["VIDEO_ID"];
                        foreach ($dbh->query($sql) as $director) {
                                $video["DIRECTOR"] .= '<a class ="person" href="?criteria=person&value=' .  $director['VALUE'] . '">' .  $director['VALUE'] . '</a> | ';
                        }
                        $video["DIRECTOR"] = substr($video["DIRECTOR"],0,strlen-3);
                        if ($i++ == $theme["EpisodesPerRow"]) { $i = 1; echo $trhtml_close.$trhtml; }
                        include($tf."videos_for_episodes.tpl");
                }
                echo $tablehtml_close;
        }
}
function navigation($type,$display,$columns=2) {

        global $tf,$view,$language,$NMJConnectString,$theme,$IsNMT;
        if ($IsNMT == 0 OR  $display == 'NoShow') {
                if ($view == 'detail' && $display == 'NoShow') {} else {
                        $dbh = new PDO($NMJConnectString);

                        if ($display == 'table') {
                                $tablehtml = '<table border="0" cellpadding="0" cellspacing="0" class="sub_navigation" id="sub_nav_'.$type.'"><tr>';
                                $tdhtml = '<td class="sub_navigation_item">';
                                $tdhtml_close = '</td>';
                                $trhtml = '<tr>';
                                $trhtml_close = '</tr>';
                                $tablehtml_close = '</table>';
                        } elseif ($display == 'div') {
                                $tablehtml = '<div class="sub_navigation" id="sub_nav_'.$type.'">';
                                $tdhtml = '<div class="sub_navigation_item">';
                                $tdhtml_close = '</div>';
                                $trhtml = '';
                                $trhtml_close = '';
                                $tablehtml_close = '</div>';
                        } elseif ($display == 'plain') {
                                $tdhtml = '';
                                $tdhtml_close = '';
                        } else {
                                $tdhtml = '  ';
                                $tdhtml_close = ' | ';
                        }

                        echo $tablehtml;

                        switch ($type) {
                                case 'category':
                                        $sql = 'SELECT ID,NAME FROM SHOW_GROUPS ORDER BY NAME';
                                        $categories = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                                        echo $trhtml;
                                        $ii = 0;
                                        foreach ($categories as $category)
                                        {

                                                $id = $category['ID'];
                                                $name = $category['NAME'];

                                                $ii++;
                                                echo $tdhtml;
                                                echo '<a class="navigation_item_link" href="?criteria=' . $type . '&value=' . $id . '">' . $name . '</a>';
                                                echo $tdhtml_close;
                                                if ($ii == $theme["SMCategoryColumns"]) {echo $trhtml_close.$trhtml;$ii = 0;}
                                        }
                                        if ($ii != 0) {echo $trhtml_close;}
                                        break;
                                case 'genre':
                                        $sql = 'SELECT DISTINCT NAME FROM VIDEO_GENRES ORDER BY NAME';
                                        $genres = $dbh->query($sql)->fetchAll(PDO::FETCH_ASSOC);
                                        echo $trhtml;
                                        $ii = 0;

                                        foreach ($genres as $genre) {

                                                $ii++;
                                                $thisgenre = $genre['NAME'];
                                                echo $tdhtml.'<a class="navigation_item_link" href="?criteria=' . $type . '&value=' . $thisgenre . '">' . $thisgenre . '</a>'.$tdhtml_close;
                                                if ($ii == $theme["SMGenreColumns"]) {echo $trhtml_close.$trhtml;$ii = 0;}
                                        }
                                        if ($ii != 0) {echo $trhtml_close;}
                                        break;
                                case 'rating':
                                        $ii = 0;
                                        for ($i = 0; $i <= 10; $i++) {
                                                $ii++;
                                                echo $trhtml.$tdhtml.'<a class="navigation_item_link" href="?criteria=' . $type . '&value=' . $i . '">' . $i . '</a>'.$tdhtml_close.$trhtml_close;
                                                if ($ii == $theme["SMRatingColumns"]) {echo $trhtml_close.$trhtml;$ii = 0;}
                                        }
                                        break;

                        }
                        echo $trhtml_close.$tablehtml_close;
                }
        }
}
         function human_filesize($size, $precision = 2)
         {
                 $size = str_replace( "-", "", $size );
                 $a_size = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
                 $count  = count($a_size) - 1;
                 $i = 0;
                 while ($size / 1024 >= 1 && $count >= $i)
                 {
                         $size = $size / 1024;
                         $i++;
                 }
                 return round($size, $precision) . ' ' . $a_size[$i];
         }
function endtime() {
    global $starttime;

    $mtime = microtime();
    $mtime = explode(" ", $mtime);
    $mtime = $mtime[1] + $mtime[0];
    $endtime = $mtime;
    $totaltime = ($endtime - $starttime);
    return substr($totaltime, 0, 5);
}
?>